﻿_this = this;
// hide editors
//_parent.mapEditor_mc._x = _parent.mapEditor_mc._width;
//_parent.collisionEditor_mc._x = _parent.collisionEditor_mc._width;
// disable keyboard shortcuts
_this.keyboardActive = false;
_this._parent.mapEditor_mc.active = false;
_this._parent.collisionEditor_mc.active = false;


doShift = function( horz, vert )
{
	// shift horz
	var xDir = Math.abs(horz) / horz;		// +1, -1
	for(var xShift = 0; xShift<Math.abs(horz); xShift++ )
	{
		if(xDir > 0)
		{// dir = right
			// shift layer data
			for(var L=0; L<DATA.map.layers.length; L++)
			{
				var thisData = DATA.map.layers[L];
				var newColumn = new Array();
				// // copy right column to new column
				var lastColumn = thisData.length-1;
				var copyColumn = thisData[lastColumn];
				for(var yPos=0; yPos<copyColumn.length; yPos++)
				{
					var newColumnValue = copyColumn[yPos];
					newColumn.push( newColumnValue );
				}// for:  Each value down the right column
				// // add column on the left
				thisData.splice( 0, 0, newColumn );
				// // remove right column
				thisData.splice( thisData.length-1, 1 );
			}// for:  layers
			
			// shift collision data
			// // copy right column to new column
			var thisData = DATA.map.collision;
			var lastIndex = thisData.length-1;
			var copyColumn = thisData[lastIndex];
			// // add column on the left
			thisData.splice( 0, 0, copyColumn );
			// // remove right column
			thisData.splice( thisData.length-1, 1 );
		}// dir = right
		else
		{// dir = left
			// shift layer data
			for(var L=0; L<DATA.map.layers.length; L++)
			{
				var thisData = DATA.map.layers[L];
				var newColumn = new Array();
				// // copy left column to new column
				var copyColumn = thisData[0];
				for(var yPos=0; yPos<copyColumn.length; yPos++)
				{
					var newColumnValue = copyColumn[yPos];
					newColumn.push( newColumnValue );
				}// for:  Each value down the left column
				// // add column on the right
				thisData.splice( thisData.length, 0, newColumn );
				// // remove left column
				thisData.splice( 0, 1 );
			}// for:  layers
			
			// shift collision data
			// // copy right column to new column
			var thisData = DATA.map.collision;
			// copy left column
			var copyLeft = thisData[0];
			// // add column onto the right
			thisData.push(copyLeft);
			// // remove from left
			thisData.splice( 0, 1 );
		}// dir = left
	}// for:  horz
	
	
	// shift vert
	var yDir = Math.abs(vert) / vert;		// +1, -1
	for(var yShift = 0; yShift<Math.abs(vert); yShift++)
	{
		if(yDir > 0)
		{// dir = down
			// shift layer & collision data
			for(var L=0; L<DATA.map.layers.length; L++)
			{
				var thisData = DATA.map.layers[L];
				for(var xPos = 0; xPos<thisData.length; xPos++)
				{
					// // copy bottom
					var bottomIndex = thisData[xPos].length-1;
					var bottomValue = thisData[xPos][bottomIndex];
					// // add onto the top
					thisData[xPos].splice(0,0, bottomValue );
					// // remove bottom
					var bottomIndex = thisData[xPos].length-1;
					thisData[xPos].splice(bottomIndex,1 );
				}// for:  xPos
			}// for:  layers
			
			// shift collision data
			// // copy bottom row to new row
			var thisData = DATA.map.collision;
			for(var xPos = 0; xPos<thisData.length; xPos++)
			{
				// // copy bottom
				var bottomIndex = thisData[xPos].length-1;
				var bottomValue = thisData[xPos][bottomIndex];
				// // add onto the top
				thisData[xPos].splice(0,0, bottomValue );
				// // remove bottom
				var bottomIndex = thisData[xPos].length-1;
				thisData[xPos].splice(bottomIndex,1 );
			}// for:  xPos
		}// dir = down
		else
		{// dir = up
			// shift layer data
			for(var L=0; L<DATA.map.layers.length; L++)
			{
				var thisData = DATA.map.layers[L];
				for(var xPos = 0; xPos<thisData.length; xPos++)
				{
					// // copy top
					var topValue = thisData[xPos][0];
					// // add onto the bottom
					var bottomIndex = thisData[xPos].length;
					thisData[xPos].splice(bottomIndex,0, topValue );
					// // remove top
					thisData[xPos].splice(0,1 );
				}// for:  xPos
			}// for:  layers
			
			// shift collision data
			// // copy top row to new row
			var thisData = DATA.map.collision;
			for(var xPos = 0; xPos<thisData.length; xPos++)
			{
				// // copy top
				var topValue = thisData[xPos][0];
				// // add onto the bottom
				var bottomIndex = thisData[xPos].length;
				thisData[xPos].splice(bottomIndex,0, topValue );
				// // remove top
				thisData[xPos].splice(0,1 );
			}// for:  xPos
		}// dir = up
	}// for:  vert
	
	// reset the map display
		_parent.gotoAndPlay("reset");
}// doShift()


var passedData = {
	ok:doShift
}
#include "functions/makeWindow.as"
var shiftWin = makeWindow( "shiftMap_mc", "Shift Map", true, passedData );


shiftWin.onClose = function()
{
	// enable keyboard shortcuts
	_this.keyboardActive = true;
	_this._parent.mapEditor_mc.active = true;
	_this._parent.collisionEditor_mc.active = true;
	// show editors
	_parent.mapEditor_mc._x = 0;
	_parent.collisionEditor_mc._x = 0;
}// onClose()